<?php
/**
 * Database Configuration
 * SQLite connection settings for GulfSportz API
 */

class Database {
    private $db_path;
    private $conn;

    public function __construct() {
        $this->db_path = __DIR__ . '/../database/database.sqlite';
    }

    /**
     * Get database connection
     * @return PDO|null
     */
    public function getConnection() {
        $this->conn = null;

        try {
            if (!file_exists($this->db_path)) {
                // Try create directory if it doesn't exist
                $dir = dirname($this->db_path);
                if (!is_dir($dir)) {
                    mkdir($dir, 0777, true);
                }
                // The file will be created by PDO if it doesn't exist and we have permissions
            }

            $dsn = "sqlite:" . $this->db_path;
            $options = [
                PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                PDO::ATTR_EMULATE_PREPARES => false,
            ];

            $this->conn = new PDO($dsn, null, null, $options);
            // Enable foreign keys for SQLite
            $this->conn->exec("PRAGMA foreign_keys = ON;");
            
        } catch(PDOException $e) {
            error_log("Connection Error: " . $e->getMessage());
            http_response_code(500);
            echo json_encode([
                'success' => false,
                'message' => 'Database connection failed: ' . $e->getMessage()
            ]);
            exit;
        }

        return $this->conn;
    }
}
