<?php
/**
 * Club Controller
 */

require_once __DIR__ . '/../models/Club.php';
require_once __DIR__ . '/../utils/response.php';

class ClubController {
    private $clubModel;

    public function __construct() {
        $this->clubModel = new ClubModel();
    }

    public function getAll() {
        try {
            $clubs = $this->clubModel->getAll();
            sendSuccess('Clubs retrieved', $clubs);
        } catch (Exception $e) {
            sendError($e->getMessage(), 500);
        }
    }

    public function getDetails($id) {
        try {
            $club = $this->clubModel->getById($id);
            if (!$club) {
                sendError('Club not found', 404);
            }
            sendSuccess('Club details retrieved', $club);
        } catch (Exception $e) {
            sendError($e->getMessage(), 500);
        }
    }

    public function create() {
        try {
            $data = json_decode(file_get_contents('php://input'), true);
            validateRequired($data, ['club_name']);
            $club = $this->clubModel->create($data);
            sendSuccess('Club created successfully', $club, 201);
        } catch (Exception $e) {
            sendError($e->getMessage(), 500);
        }
    }

    public function update($id) {
        try {
            $data = json_decode(file_get_contents('php://input'), true);
            $result = $this->clubModel->update($id, $data);
            if (!$result) {
                sendError('Club not found or nothing to update', 404);
            }
            sendSuccess('Club updated successfully');
        } catch (Exception $e) {
            sendError($e->getMessage(), 500);
        }
    }

    public function delete($id) {
        try {
            $result = $this->clubModel->delete($id);
            if (!$result) {
                sendError('Club not found', 404);
            }
            sendSuccess('Club deleted successfully');
        } catch (Exception $e) {
            sendError($e->getMessage(), 500);
        }
    }
}
