<?php
/**
 * League Controller
 */

require_once __DIR__ . '/../models/League.php';
require_once __DIR__ . '/../utils/response.php';

class LeagueController {
    private $leagueModel;

    public function __construct() {
        $this->leagueModel = new LeagueModel();
    }

    public function getAll() {
        try {
            $leagues = $this->leagueModel->getAll();
            sendSuccess('Leagues retrieved', $leagues);
        } catch (Exception $e) {
            sendError($e->getMessage(), 500);
        }
    }

    public function getDetails($id) {
        try {
            $league = $this->leagueModel->getById($id);
            if (!$league) {
                sendError('League not found', 404);
            }
            sendSuccess('League details retrieved', $league);
        } catch (Exception $e) {
            sendError($e->getMessage(), 500);
        }
    }

    public function create() {
        try {
            $data = json_decode(file_get_contents('php://input'), true);
            validateRequired($data, ['name', 'slug', 'sport_id']);
            $league = $this->leagueModel->create($data);
            sendSuccess('League created successfully', $league, 201);
        } catch (Exception $e) {
            sendError($e->getMessage(), 500);
        }
    }

    public function update($id) {
        try {
            $data = json_decode(file_get_contents('php://input'), true);
            $result = $this->leagueModel->update($id, $data);
            if (!$result) {
                sendError('League not found or nothing to update', 404);
            }
            sendSuccess('League updated successfully');
        } catch (Exception $e) {
            sendError($e->getMessage(), 500);
        }
    }

    public function delete($id) {
        try {
            $result = $this->leagueModel->delete($id);
            if (!$result) {
                sendError('League not found', 404);
            }
            sendSuccess('League deleted successfully');
        } catch (Exception $e) {
            sendError($e->getMessage(), 500);
        }
    }
}
