<?php
/**
 * Stats Controller
 */

require_once __DIR__ . '/../models/Stats.php';
require_once __DIR__ . '/../utils/response.php';

class StatsController {
    private $statsModel;

    public function __construct() {
        $this->statsModel = new StatsModel();
    }

    public function getStats() {
        try {
            $matchId = $_GET['match_id'] ?? null;
            if ($matchId) {
                $data = $this->statsModel->getByMatch($matchId);
            } else {
                $data = $this->statsModel->getGlobalStats();
            }
            sendSuccess('Stats retrieved', $data);
        } catch (Exception $e) {
            sendError($e->getMessage(), 500);
        }
    }

    public function update() {
        try {
            $data = json_decode(file_get_contents('php://input'), true);
            validateRequired($data, ['player_id', 'match_id']);
            $this->statsModel->createOrUpdate($data);
            sendSuccess('Stats updated successfully');
        } catch (Exception $e) {
            sendError($e->getMessage(), 500);
        }
    }
}
