<?php
/**
 * Upload Controller
 */

require_once __DIR__ . '/../utils/response.php';

class UploadController {
    public function upload() {
        if (!isset($_FILES['file'])) {
            sendError('No file uploaded', 400);
        }

        $file = $_FILES['file'];
        $fileName = $file['name'];
        $fileTmpName = $file['tmp_name'];
        $fileSize = $file['size'];
        $fileError = $file['error'];
        $fileType = $file['type'];

        $fileExt = explode('.', $fileName);
        $fileActualExt = strtolower(end($fileExt));

        $allowed = array('jpg', 'jpeg', 'png', 'gif', 'webp', 'pdf');

        if (in_array($fileActualExt, $allowed)) {
            if ($fileError === 0) {
                if ($fileSize < 5000000) { // 5MB limit
                    $fileNameNew = uniqid('', true) . "." . $fileActualExt;
                    $fileDestination = __DIR__ . '/../public/uploads/' . $fileNameNew;
                    
                    if (move_uploaded_file($fileTmpName, $fileDestination)) {
                        // Return the URL
                        $protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http";
                        $host = $_SERVER['HTTP_HOST'];
                        $url = "$protocol://$host/uploads/$fileNameNew";
                        
                        sendSuccess('File uploaded successfully', ['url' => $url]);
                    } else {
                        sendError('Failed to move uploaded file', 500);
                    }
                } else {
                    sendError('File is too large', 400);
                }
            } else {
                sendError('There was an error uploading your file', 400);
            }
        } else {
            sendError('Invalid file type', 400);
        }
    }
}
