<?php
/**
 * User Controller
 */

require_once __DIR__ . '/../models/User.php';
require_once __DIR__ . '/../utils/response.php';

class UserController {
    private $userModel;

    public function __construct() {
        $this->userModel = new User();
    }

    /**
     * Register new user
     */
    public function register() {
        $data = json_decode(file_get_contents('php://input'), true);
        
        if (!$data) {
            sendError('Invalid request data', 400);
        }
        
        try {
            $user = $this->userModel->create($data);
            sendSuccess('User registered successfully', $user, 201);
        } catch (Exception $e) {
            sendError($e->getMessage(), 500);
        }
    }

    /**
     * Login user
     */
    public function login() {
        $data = json_decode(file_get_contents('php://input'), true);
        
        validateRequired($data, ['email', 'password']);
        
        $email = sanitizeInput($data['email']);
        $password = $data['password'];
        
        try {
            $result = $this->userModel->login($email, $password);
            sendSuccess('Login successful', $result);
        } catch (Exception $e) {
            sendError($e->getMessage(), 401);
        }
    }

    /**
     * Get current user profile
     */
    public function getProfile() {
        $payload = requireAuth();
        $user = $this->userModel->getById($payload['user_id']);
        sendSuccess('Profile retrieved', $user);
    }
}

