<?php
/**
 * API Entry Point
 */

require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../controllers/UserController.php';
require_once __DIR__ . '/../utils/response.php';

// CORS Headers
header("X-Codebase: gulfsportz");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With");

// Handle preflight OPTIONS request
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

// Get request method and URI
$method = $_SERVER['REQUEST_METHOD'];
$uri = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
$uri = str_replace('/api/public', '', $uri);
$uri = trim($uri, '/');
$segments = explode('/', $uri);

// Route handling
try {
    if ($segments[0] === 'users' || $segments[0] === 'auth') {
        $controller = new UserController();
        
        if ($segments[0] === 'auth' && isset($segments[1])) {
            if ($segments[1] === 'register' && $method === 'POST') {
                $controller->register();
            } elseif ($segments[1] === 'login' && $method === 'POST') {
                $controller->login();
            } else {
                sendError('Endpoint not found', 404);
            }
        } elseif ($segments[0] === 'users' && isset($segments[1])) {
            if ($segments[1] === 'profile' && $method === 'GET') {
                $controller->getProfile();
            } else {
                sendError('Endpoint not found', 404);
            }
        } else {
            sendError('Endpoint not found', 404);
        }
    } elseif ($segments[0] === 'matches') {
        require_once __DIR__ . '/../controllers/MatchController.php';
        $controller = new MatchController();

        if ($method === 'GET') {
            if (isset($segments[1]) && $segments[1] === 'live') {
                $controller->getLiveMatches();
            } elseif (isset($segments[1]) && $segments[1] === 'admin') {
                $controller->index();
            } elseif (isset($segments[1]) && $segments[1] === 'sport' && isset($segments[2])) {
                $controller->getBySport($segments[2]);
            } elseif (isset($segments[1])) {
                $controller->getDetails($segments[1]);
            } else {
                sendError('Endpoint not found', 404);
            }
        } elseif ($method === 'POST') {
            $controller->create();
        } elseif ($method === 'PUT' && isset($segments[1])) {
            $controller->update($segments[1]);
        } elseif ($method === 'DELETE' && isset($segments[1])) {
            $controller->delete($segments[1]);
        } else {
            sendError('Method not allowed', 405);
        }
    } elseif ($segments[0] === 'news') {
        require_once __DIR__ . '/../controllers/NewsController.php';
        $controller = new NewsController();

        if ($method === 'GET') {
            if (!isset($segments[1])) {
                $controller->getLatest();
            } elseif ($segments[1] === 'admin') {
                $controller->index();
            } elseif ($segments[1] === 'sport' && isset($segments[2])) {
                $controller->getBySport($segments[2]);
            } else {
                $controller->getArticle($segments[1]);
            }
        } elseif ($method === 'POST') {
            if (isset($segments[1]) && isset($segments[2])) {
                if ($segments[2] === 'like') {
                    $controller->incrementLike($segments[1]);
                } elseif ($segments[2] === 'comments') {
                    $controller->postComment($segments[1]);
                } else {
                    sendError('Endpoint not found', 404);
                }
            } else {
                $controller->create();
            }
        } elseif ($method === 'PUT' && isset($segments[1])) {
            $controller->update($segments[1]);
        } elseif ($method === 'DELETE' && isset($segments[1])) {
            $controller->delete($segments[1]);
        } else {
            sendError('Method not allowed', 405);
        }
    } elseif ($segments[0] === 'players') {
        require_once __DIR__ . '/../controllers/PlayerController.php';
        $controller = new PlayerController();

        if ($method === 'GET') {
            if (isset($segments[1]) && $segments[1] === 'featured') {
                $controller->getFeatured();
            } elseif (isset($segments[1]) && $segments[1] === 'admin') {
                $controller->index();
            } elseif (isset($segments[1]) && $segments[1] === 'sport' && isset($segments[2])) {
                $controller->getBySport($segments[2]);
            } elseif (isset($segments[1])) {
                $controller->getDetails($segments[1]);
            } else {
                sendError('Endpoint not found', 404);
            }
        } elseif ($method === 'POST') {
            $controller->create();
        } elseif ($method === 'PUT' && isset($segments[1])) {
            $controller->update($segments[1]);
        } elseif ($method === 'DELETE' && isset($segments[1])) {
            $controller->delete($segments[1]);
        } else {
            sendError('Method not allowed', 405);
        }
    } elseif ($segments[0] === 'standings') {
        require_once __DIR__ . '/../controllers/StandingsController.php';
        $controller = new StandingsController();

        if ($method === 'GET') {
            $controller->getStandings();
        } elseif ($method === 'POST') {
            $controller->update();
        } else {
            sendError('Method not allowed', 405);
        }
    } elseif ($segments[0] === 'sports') {
        require_once __DIR__ . '/../controllers/SportsController.php';
        $controller = new SportsController();

        if ($method === 'GET') {
            if (!isset($segments[1])) {
                $controller->getAll();
            } else {
                $controller->getDetails($segments[1]);
            }
        } elseif ($method === 'POST') {
            $controller->create();
        } elseif ($method === 'PUT' && isset($segments[1])) {
            $controller->update($segments[1]);
        } elseif ($method === 'DELETE' && isset($segments[1])) {
            $controller->delete($segments[1]);
        } else {
            sendError('Method not allowed', 405);
        }
    } elseif ($segments[0] === 'clubs') {
        require_once __DIR__ . '/../controllers/ClubController.php';
        $controller = new ClubController();

        if ($method === 'GET') {
            if (!isset($segments[1])) {
                $controller->getAll();
            } else {
                $controller->getDetails($segments[1]);
            }
        } elseif ($method === 'POST') {
            $controller->create();
        } elseif ($method === 'PUT' && isset($segments[1])) {
            $controller->update($segments[1]);
        } elseif ($method === 'DELETE' && isset($segments[1])) {
            $controller->delete($segments[1]);
        } else {
            sendError('Method not allowed', 405);
        }
    } elseif ($segments[0] === 'stats') {
        require_once __DIR__ . '/../controllers/StatsController.php';
        $controller = new StatsController();

        if ($method === 'GET') {
            $controller->getStats();
        } elseif ($method === 'POST') {
            $controller->update();
        } else {
            sendError('Method not allowed', 405);
        }
    } elseif ($segments[0] === 'leagues') {
        require_once __DIR__ . '/../controllers/LeagueController.php';
        $controller = new LeagueController();

        if ($method === 'GET') {
            if (!isset($segments[1])) {
                $controller->getAll();
            } else {
                $controller->getDetails($segments[1]);
            }
        } elseif ($method === 'POST') {
            $controller->create();
        } elseif ($method === 'PUT' && isset($segments[1])) {
            $controller->update($segments[1]);
        } elseif ($method === 'DELETE' && isset($segments[1])) {
            $controller->delete($segments[1]);
        } else {
            sendError('Method not allowed', 405);
        }
    } elseif ($segments[0] === 'upload' && $method === 'POST') {
        require_once __DIR__ . '/../controllers/UploadController.php';
        $controller = new UploadController();
        $controller->upload();
    } elseif ($segments[0] === 'stats') {
        // Simple mock stats endpoint
        sendSuccess('Stats retrieved', [
            ['icon' => 'Trophy', 'label' => 'Live Matches', 'value' => '24', 'change' => '+3 today'],
            ['icon' => 'Users', 'label' => 'Registered Players', 'value' => '12.5K', 'change' => '+156 this week'],
            ['icon' => 'MapPin', 'label' => 'Covered Venues', 'value' => '89', 'change' => 'Across 7 Emirates'],
            ['icon' => 'BarChart3', 'label' => 'Stats Tracked', 'value' => '1.2M', 'change' => 'Data points'],
            ['icon' => 'Target', 'label' => 'Goals Recorded', 'value' => '8,432', 'change' => 'This season'],
            ['icon' => 'TrendingUp', 'label' => 'Monthly Views', 'value' => '4.8M', 'change' => '+22% growth']
        ]);
    } else {
        sendError('Endpoint not found', 404);
    }
} catch (Exception $e) {
    sendError('Internal server error: ' . $e->getMessage(), 500);
}
