<?php
/**
 * Authentication Helper Functions
 */

function hashPassword($password) {
    return password_hash($password, PASSWORD_ALGO, PASSWORD_OPTIONS);
}

function verifyPassword($password, $hash) {
    return password_verify($password, $hash);
}

function generateToken($userId, $userType) {
    // Simple token generation (in production, use JWT)
    $payload = [
        'user_id' => $userId,
        'user_type' => $userType,
        'exp' => time() + (7 * 24 * 60 * 60) // 7 days
    ];
    
    return base64_encode(json_encode($payload));
}

function getAuthToken() {
    $headers = getallheaders();
    
    if (isset($headers['Authorization'])) {
        $authHeader = $headers['Authorization'];
        if (preg_match('/Bearer\s+(.*)$/i', $authHeader, $matches)) {
            return $matches[1];
        }
    }
    
    return null;
}

function verifyToken($token) {
    try {
        $payload = json_decode(base64_decode($token), true);
        
        if (!isset($payload['exp']) || $payload['exp'] < time()) {
            return null;
        }
        
        return $payload;
    } catch (Exception $e) {
        return null;
    }
}

function requireAuth() {
    $token = getAuthToken();
    
    if (!$token) {
        sendError('Authentication required', 401);
    }
    
    $payload = verifyToken($token);
    
    if (!$payload) {
        sendError('Invalid or expired token', 401);
    }
    
    return $payload;
}

